.H 1 "Source Text Window"
Source Text windows display source code.
Each source file has its own Source Text window.
The menus set and clear breakpoints, open the Frame windows,
show the assembly code implementing a statement,
and find functions in the file by name.
.H 2 "Source Text Layout"
The title bar displays the name of the source file.
Most of the lines in the window display the source code without modification.
However, special character sequences are inserted at the beginning of
lines containing breakpoints.
If a regular (unconditional) breakpoint is placed at a line,
the characters ">>>" are inserted at the beginning.
When a breakpoint is hit, the process will stop before the
first assembler instruction implementing the statement is executed.
For example, the line
.DS I N
>>>	j++;
.DE
.P
stops the process before the variable j is incremented.
Hitting a breakpoint causes pi to select the line in the
Source Text window that set the breakpoint.
.P
Conditional breakpoints are breakpoints that evaluate a C expression
when they are hit,
and either stop or continue the process depending on whether
the expression is true or false.
If you have set a conditional breakpoint at a line with its line menu,
but haven't specified the condition yet, the characters
.DS I N
if( ? ) >>>
.DE
.P
are placed on the beginning of the line,
indicating the line is waiting for you to type in
the C expression to use for the condition.
After an expression has been entered, the `?' character is
replaced with the expression.
For example, to stop on a line when the value of i is equal to 5:
.AL 1
.LI
Select the line with the mouse.
.LI
Choose the "cond bpt" entry in the line's menu.
.LI
Type in the condition "i==5".
.LE
.P
The line will be redisplayed as
.DS I N
if(i==5)>>>	original_statement;
.DE
.P
The inserted text expresses that setting a conditional breakpoint
is equivalent to adding the C statement "if(expression) >>>"
to the code, where ">>>" represents the breakpoint handler.
.P
When a conditional breakpoint is hit,
the source line corresponding to the breakpoint is
selected and the C expression is evaluated and printed.
The displayed format for the lines becomes:
.DS I N
if([count]expression=value)>>> original_statement;
.DE
.P
where count is the number of times the breakpoint has been hit,
expression is the C expression evaluated,
and value is the expression's value.
The count is an attribute of the source line, and not the breakpoint
so if you remove the breakpoint and later add another 
one, count reflects the cumulative hits to the statement.
.P
When a conditional breakpoint is hit, the source line is selected
and displayed in reverse video whether the condition is true or false.
If the condition is false the process starts executing again.
If you have several conditional breakpoints set on different lines
and their conditions are all false, they will flash in sequence
as the process hits them.
The sequence the source lines flash in provides a primitive type of 
algorithm animation.
.P
Because conditional breakpoints display the values of any
expressions evaluated, the C
comma operator is useful for tracing a set of variables in the condition.
If two expressions are separated by a comma,
the expressions are evaluated left-to-right, and the 
value of the left expression is discarded.
For example, if the breakpoint condition is:
.DS I N
i, j, i==5
.DE
.P
each time the conditional breakpoint is hit,
the values of the variables i and j are
displayed along with the value of the expression i==5,
and when the value of the expression i==5 is non-zero,
the process stops.
This causes the line to be displayed as:
.DS I N
if([6] i=5, j=29, i==5=1)>>>	original_statement;
.DE
.P
The format used to print the values of variables in conditional breakpoints
is inherited from their settings in Frame windows.
.P
A tracepoint is a special conditional breakpoint that uses
0 for the condition.
Since this condition is never non-zero,
a tracepoint never stops the process.
Setting a tracepoint from the line menu inserts the characters
.DS I N
if(0)>>>
.DE
.P
at the beginning of the line.
When a tracepoint is hit, the line flashes and the breakpoint 
count field is updated.
After the tracepoint is hit the first time, the displayed format changes to:
.DS I N
if([count] 0=0)>>>	original_statement;
.DE
.H 2 "Source Text Opening Errors"
When a Source Text window is opened,
the file containing the source code is opened and read into the window.
Several things can go wrong.
If pi cannot open the file because you are in the wrong directory, the file
is not on the source file search path, or the file has moved,
the error message:
.DS I N
cannot open: No such file or directory
.DE
.P
is placed on the first line in the Source Text window.
You have several options for reopening the file.
.AL 1
.LI
Enter a source file search path into the Source Files window using
that window's keyboard language,
and then choose the "reopen" button in the Source Text window's menu bar.
This search path will be used when opening any
subsequent Source Text windows.
You can set the default value of the search path by
setting the PI_SRCPATH environment variable before pi is started.
.LI
Use the "src" menu in the Source Files window menu bar
to try using the full path names extracted from the symbol table.
.LI
Change the directory of the debugger from the Directory window,
and then choose the "reopen" menu entry in the Source Text window's menu bar.
.LI
Type in a correct file name to the Source Text window.
When the window is in this error state,
the window's keyboard language accepts an alternate file name.
This is the easiest method if only a single file name needs to be overridden.
.LE
.P
Pi performs several consistency checks before the source file is read in.
The modification date of the source file is compared with the
modification date of the executable file containing the symbol
table to insure the source file hasn't been modified since the program
was compiled.
If the source file is newer, the file is not read in and a message, such as:
.DS I N
modified since compilation at Tue May 15 10:48:39 1990
.DE
.P
is put on the first line to warn you that
the program-address-to-source-code-line mappings in the symbol table
file may not be correct for this source file.
At this point, you may force pi to read in the file anyway,
by selecting the "reopen" button in the menu bar,
or you may change the file being read in by using one of the options
given above.
.H 2 "Source Text Menu Bar"
.VL 12 1
.LI "reopen"
Reopen the source file and read it back into the window.
This entry is useful if you accidentally read in the wrong file.
.LI "func index"
For each function in the source file this menu will contain an entry of
the form "function()...linenumber".
These entries allow you to locate source code for a function
in the file by name.
Choosing an entry displays the first line of source code for
that function.
The entries are sorted alphabetically so they are easy to find.
If the file contains C++ code, the argument prototypes are also
placed in the menu entries, allowing overloaded function names
to be distinguished.
.H 2 "Source Text Keyboard"
Syntax
.DS I N
/[string]
?string
linenumber
.DE
.P
The window's keyboard language allows to you search for strings in
the source file, or select a line by its line number.
Note that every line in the Source Text window provides a line
keyboard language,
so you must make sure no line is selected in the window to 
send keyboard input to the window.
.P
The "/[string]" syntax searches forward in the window for the
next instance of string.
If a match is found, the window scrolls to that line and selects it.
The string is not a regular expression and must match 
the characters exactly.
The search begins on the last line that was selected in the window.
If no match is found and the last line in the window is
reached, the search will wrap around and continue on the first line.
The string is optional and if not present, the
string used in the last search request will be used.
.P
The "?string" format searches backwards in the window for the string.
The string is required because if the input line is
the single character `?', pi's help mechanism is invoked.
.P
The "linenumber" format scrolls the window to the given
line number and selects the line.
Line numbers are used infrequently in pi, as menus are usually
used to select source lines.
.H 2 "Source Text Line Menus"
.VL 13 1
.LI "set bpt"
Set a breakpoint at the selected line.
The characters ">>>" are inserted at the beginning of the
line to indicate a breakpoint has been set.
The breakpoint is set at the first instruction of the code that implements
the line, so when the breakpoint is hit the process will stop before
the statement is executed.
When a breakpoint is hit, pi selects the line in the Source Text window
where it was set.
.LI "trace on"
Set a tracepoint at the selected line.
The characters "if(0)>>>" are inserted at the
beginning of the line as an indicator.
Every time the tracepoint is hit the line will flash
and the breakpoint counter for the line will be incremented.
.LI "cond bpt"
Set a conditional breakpoint at the selected line.
The characters "if( ? )>>>" are
inserted at the beginning of the line,
indicating you need to type in a C expression to use
for the condition, and the keyboard language for the line changes
to just C expressions.
Any C expression that may be typed to a Frame window may be
used for the conditional expression.
When an expression is entered, it will displayed on the line in place of the
`?', and the breakpoint will be set in the code.
.P
When a conditional breakpoint is hit, pi evaluates the C expression
and display it's value on the line, along with the number of times
the breakpoint has been hit.
If the expression has a non-zero value the process is stopped.
Otherwise, pi resumes the process.
.LI "clear bpt"
Clear the breakpoint set on the selected line.
This menu entry is only present for lines that have breakpoints.
.LI "assembler"
Open the Assembler window and disassemble the first instruction
implementing the selected line.
The line menu in the Assembler window has entries that allow you to
disassemble the following instructions,
so you can easily examine all of the instructions
implementing a line of source code.
.LI "open frame"
Open the Frame window for the function that the selected line is in.
The Frame window can be used to examine the function's arguments
and local variables.
If the function has been called recursively, the Frame window for the most
recent activation record for the function will be opened,
and the warning message:
.DS I N
called recursively - deepest instance
.DE
.P
is printed in the Frame window when it is opened.
If there are no activation records on the stack for the function,
the error message:
.DS I N
function() is not on callstack
.DE
.P
is displayed on the second line of the Process window.
.LE
.P
If a single line of source code generates multiple functions, such as
C++ template code or in-line functions that are not coded in-line, a
more complicated line menu is created that allows the functions to be
treated individually, or as a group.
For each function generated, an entry is placed in the menu that lists
the function's name.
From that entry, a sub-menu is generated that provides the
standard Source Text line operators for that individual function.
In addition, an "all" entry at the bottom of the menu allows breakpoints
to be set and cleared in all the functions at once.
If the "all" entry is used to set a conditional breakpoint in multiple
functions, the conditional expression must be valid in all of the
functions.
.P
When a line menu operation is invoked in a Source Text window,
such as setting a breakpoint, pi uses the program-address to source-code-line
mappings obtained from the symbol table to determine the address in the program
associated with the line.
However, some lines, such as lines that are completely blank or lines
that only contain variable declarations, have no instructions associated
with them.
If a menu operation is performed on a source line that didn't
generate any code, the operation occurs on the
first line after the selected line that generated some code.
Don't be surprised if occasionally when you set a breakpoint,
the breakpoint is actually set on a line further down
in the file!
For example, if you attempt to place a breakpoint in the white space
in between functions, the breakpoint will be placed in the prologue of
the function after the selected line (the line containing
the function's leading {).
.P
If a single statement spans multiple lines, the operation is
performed on the last line implementing the statement.
For example, if a Source Text window contains the following C code:
.DS I N
1 if (i < 0 ||
2     i > 100 ||
3     i == 50)
4        statement;
.DE
.P
using the line menu to set a breakpoint on line 1, 2, or 3 causes
the ">>>" breakpoint indicator to appear on line 3.
.P
If a source line generates code in multiple places,
the operation is performed on the first
code associated with the line.
For example, the for loop in the following the C code:
.DS I N
for(i = 0; i < 10; i++) {
       statement;
}
.DE
.P
generates separate code for the initialization and iterative
parts of the for statement.
If you place a breakpoint on the "for" line, the breakpoint is
placed in the code implementing the initialization, and will only be
hit when the for loop is first entered.
.P
Some compilers arrange the program-address to source-code-line mappings
in the symbol table so that the code implementing the iterative part of
the for loop is mapped to the source line containing the for loop's
closing `}', allowing separate breakpoints to be set from the
Source Text window on both the initialization and iterative parts.
However, this has the side effect that when statement stepping over
the iterative part of the for loop, pi points to the line containing
the for loop's closing `}', instead of the line with the "for" on it.
.H 2 "Source Text Line Keyboard"
Most lines in the Source Text window accept the following keyboard input:
.P
Syntax
.DS I N
/[string]
?string
C_expression
.DE
.P
The first two formats do forward and backward string searches
and behave exactly like the string searches in the window's keyboard language.
See "Source Text Keyboard".
.P
Typing a C expression to a line is an accelerator for choosing
the "open frame" menu entry for that line, and typing the expression
into the Frame window.
The Frame window corresponding to the source
line is opened, and the C expression is evaluated and printed in that window.
For example, to see the current value of the local variable i in a function,
select any line of source code in that function and
type i followed by carriage return.
.P
The keyboard language for lines where conditional breakpoints have been set,
but the conditions have not been entered, only accept C expressions.
These lines start with the string:
.DS I N
if( ? ) >>>
.DE
.P
indicating they are waiting for you to type in the C expression
to use for the condition. 
When the expression is entered,  the "?" is replaced by the expression.
